/**
 * アラームの設定
 */

#include <Arduino.h>
#include "debug.h"
#include "HX8357.h"
#include "FontSD.h"
#include "DISP7SEG.h"
#include "ARAM.h"

ARAM aram ;

static char * onoffStr[] = { "OFF" , "ON" } ;
static char * melodyStr[] = { "未設定" , "学校のﾁｬｲﾑ" , "ﾌｧﾐﾏの音" , "ｷﾗｷﾗ星"} ;
static char * wdayStr[] = { "日" , "月" , "火" , "水" , "木" , "金" , "土"} ;

void ARAM::init( )
{
  // 新API（周波数・分解能を指定してピンに直接アタッチ）
  ledcAttach(SPEAKER_PIN, 2000, 10);
}

//チャイム演奏
void ARAM::playChime(int chNo)
{
  melody_t *melody = melody1 ;
  switch(chNo) {
    case 1: melody = melody1 ; break ;
    case 2: melody = melody2 ; break ;
    case 3: melody = melody3 ; break ;
    case 4: melody = melody4 ; break ;
  }

  for (int i=0;melody[i].tone != 0 || melody[i].length != 0;i++) {
    if (melody[i].tone == 0) {
      ledcWriteTone(SPEAKER_PIN, 0);  // 消音
    } else {
      ledcWriteTone(SPEAKER_PIN, melody[i].tone); // 音を鳴らす
    }
    delay(melody[i].length);
  }
  ledcWriteTone(SPEAKER_PIN, 0);  // 消音
}

// アラーム設定一覧を表示
void ARAM::dispAramList(bool flagCLS)
{
  if (flagCLS) { tft.fillScreen(COLOR_BLACK); }
  for (int i=0;i<5;i++) {
    int y = 8 + i* (48 + 8) ;
    tft.fillBox(8 , y     , 312 , 48 , COLOR_BLUE) ;
    tft.fillBox(10, y + 2 , 308 , 44 , COLOR_WHITE) ;
    fontSD.dispTextG(16 , y+8 , 304 , onoffStr[aram[i].enable], COLOR_MAGENTA,COLOR_WHITE,false,true) ;
    disp7seg.dispTime(68 , y+8 , aram[i].timehour ,aram[i].timemin, -1 , COLOR_DARK_GREEN,COLOR_WHITE) ;
    fontSD.dispTextG(156, y+8 , 304 , melodyStr[aram[i].melody], COLOR_BLUE,COLOR_WHITE,false,true) ;
  }

  tft.fillBox(340,64,136,48,COLOR_BLUE) ;
  tft.fillBox(342,66,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(376 , 72 , 128 , "全ON", COLOR_BLACK,COLOR_WHITE,false,true) ;

  tft.fillBox(340,120,136,48,COLOR_BLUE) ;
  tft.fillBox(342,122,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(368 , 128 , 128 , "全OFF", COLOR_BLACK,COLOR_WHITE,false,true) ;

  tft.fillBox(340,176,136,48,COLOR_BLUE) ;
  tft.fillBox(342,178,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(376 , 184 , 128 , "決定", COLOR_BLACK,COLOR_WHITE,false,true) ;

  tft.fillBox(340,232,136,48,COLOR_BLUE) ;
  tft.fillBox(342,234,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(376 , 240 , 128 , "戻る", COLOR_BLACK,COLOR_WHITE,false,true) ;
}

// アラーム設定情報を作業領域にコピー
void ARAM::copyAramToWork(int no) {
  aramWork.enable   = aram[no].enable ;
  aramWork.timehour = aram[no].timehour ;
  aramWork.timemin  = aram[no].timemin ;
  aramWork.melody   = aram[no].melody ;
  for (int d = 0; d < 7; d++) {
    aramWork.wday[d] = aram[no].wday[d] ;
  }

  DPRINTF("ARAM Copy to Work No=%d En=%d %02d:%02d Mel=%d\n",
    no,
    aramWork.enable,
    aramWork.timehour,
    aramWork.timemin,
    aramWork.melody
  ) ;
  DPRINT("WDAY:") ;
  for (int d = 0; d < 7; d++) {
    DPRINTF(" %d",aramWork.wday[d]) ;
  }
  DPRINTLN() ;
}

// アラーム設定を作業領域からコピー
void ARAM::copyWorkToAram(int no) {
  aram[no].enable   = aramWork.enable ;
  aram[no].timehour = aramWork.timehour ;
  aram[no].timemin  = aramWork.timemin ;
  aram[no].melody   = aramWork.melody ;
  for (int d = 0; d < 7; d++) {
    aram[no].wday[d] = aramWork.wday[d] ;
  }

  DPRINTF("ARAM Copy from Work No=%d En=%d %02d:%02d Mel=%d\n",
    no,
    aram[no].enable,
    aram[no].timehour,
    aram[no].timemin,
    aram[no].melody
  ) ;
  DPRINT("WDAY:") ;
  for (int d = 0; d < 7; d++) {
    DPRINTF(" %d",aram[no].wday[d]) ;
  }
  DPRINTLN() ;
}

// アラーム設定編集画面を表示
void ARAM::dispEditAram(bool flagCLS)
{
  DPRINTF("dispEditAram En=%d %02d:%02d Mel=%d\n",
    aramWork.enable,
    aramWork.timehour,
    aramWork.timemin,
    aramWork.melody
  ) ;
  if (flagCLS) { tft.fillScreen(COLOR_BLACK); }

  tft.fillBox(8 , 108 , 68 , 48 , COLOR_BLUE) ;
  tft.fillBox(10, 110 , 64 , 44 , COLOR_WHITE) ;
  fontSD.dispTextG(14 , 116 , 304 , onoffStr[aramWork.enable], COLOR_MAGENTA,COLOR_WHITE,false,true) ;

  tft.fillBox(80, 108 , 100 , 48 , COLOR_BLUE) ;
  tft.fillBox(82, 110 , 96 , 44 , COLOR_WHITE) ;
  disp7seg.dispTime(84 , 116 , aramWork.timehour ,aramWork.timemin, -1 , COLOR_DARK_GREEN,COLOR_WHITE) ;

  tft.fillBox(80, 28  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(82, 30  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(84 , 32 , 128 , "▲▲", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(80, 68  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(82, 70  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(92 , 72 , 128 , "▲", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(80, 172  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(82, 174  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(92 , 176 , 128 , "▼", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(80, 212  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(82, 214  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(84 , 216 , 128 , "▼▼", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(184, 108 , 176 , 48 , COLOR_BLUE) ;
  tft.fillBox(186, 110 , 172 , 44 , COLOR_WHITE) ;
  fontSD.dispTextG(188, 116 , 304 , melodyStr[aramWork.melody], COLOR_BLUE,COLOR_WHITE,false,true) ;

  tft.fillBox(144, 28  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(146, 30  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(148 , 32 , 128 , "▲▲", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(144, 68  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(146, 70  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(156 , 72 , 128 , "▲", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(144, 172  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(146, 174  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(156 , 176 , 128 , "▼", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(144, 212  , 36 , 24 , COLOR_DARK_GREEN) ;
  tft.fillBox(146, 214  , 32 , 20 , COLOR_WHITE) ;
  fontSD.dispTextG(148 , 216 , 128 , "▼▼", COLOR_GREEN,COLOR_WHITE) ;

  tft.fillBox(340,176,136,48,COLOR_BLUE) ;
  tft.fillBox(342,178,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(376 , 184 , 128 , "決定", COLOR_BLACK,COLOR_WHITE,false,true) ;

  tft.fillBox(340,232,136,48,COLOR_BLUE) ;
  tft.fillBox(342,234,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(376 , 240 , 128 , "戻る", COLOR_BLACK,COLOR_WHITE,false,true) ;

  for (int i=0;i<7;i++) {
    int x = 208 + i * (24 + 16) ;
    uint16_t wdColorF = (aramWork.wday[i] == 0) ? COLOR_WHITE : COLOR_BLACK ;
    uint16_t wdColorB = (aramWork.wday[i] == 0) ? COLOR_DARK_GRAY : COLOR_CYAN ;
    tft.fillBox(x, 28  , 24 , 24 , COLOR_BLUE) ;
    tft.fillBox(x+1, 29  , 22 , 22 , wdColorB) ;
    fontSD.dispTextG(x+4 , 32 , 20 , wdayStr[i], wdColorF , wdColorB) ;
  }
}

int ARAM::checkMenuTouch(uint16_t x, uint16_t y) 
{
  if (340<=x && x<476 && 64<=y && y<112) {
    for (int i = 0; i < 5 ; i++) {
      // 全ON
      aram[i].enable = 1 ;
    }
    dispAramList(false) ;
    return 0 ;
  }
  if (340<=x && x<476 && 120<=y && y<168) {
    // 全OFF
    for (int i = 0; i < 5 ; i++) {
      aram[i].enable = 0 ;
    }
    dispAramList(false) ;
    return 0 ;
  }
  if (340<=x && x<476 && 232<=y && y<280) {
    return 10 ; // 戻る
  }
  if (340<=x && x<476 && 176<=y && y<224) {
    return 20 ; // 決定
  }

  for (int i=0;i<5;i++) {
    int by = 8 + i* (48 + 8) ;
    if (8<=x && x<320 && by<=y && y<by+48) {
      return i+1 ; // チャイム選択
    }
  }
  return 0 ;
}

int ARAM::checkEditMenuTouch(uint16_t x, uint16_t y) 
{
  if (340<=x && x<476 && 232<=y && y<280) {
    return 10 ; // 戻る
  }
  if (340<=x && x<476 && 176<=y && y<224) {
    return 20 ; // 決定
  }

  if (8 <=x && x<76 && 108<=y && y<156) {
    aramWork.enable = (aramWork.enable == 0) ? 1 : 0 ;
    dispEditAram(false) ;
  }
  if (184 <=x && x<320 && 108<=y && y<156) {
    aramWork.melody = (aramWork.melody + 1) % 4 ;
    if (aramWork.melody == 0) { aramWork.melody = 1 ; }
    dispEditAram(false) ;
  }

  if (80 <=x && x<116) {
    if (28 <=y && y<52) {
      // 時間▲▲
      aramWork.timehour = (aramWork.timehour + 5) % 24 ;
      dispEditAram(false) ;
    } else
    if (68 <=y && y<92) {
      // 時間▲
      aramWork.timehour = (aramWork.timehour + 1) % 24 ;
      dispEditAram(false) ;
    } else
    if (172 <=y && y<196) {
      // 時間▼
      aramWork.timehour = (aramWork.timehour + 23) % 24 ;
      dispEditAram(false) ;
    } else
    if (212 <=y && y<236) {
      // 時間▼▼
      aramWork.timehour = (aramWork.timehour + 19) % 24 ;
      dispEditAram(false) ;
    }
  }

  if (144 <=x && x<180) {
    if (28 <=y && y<52) {
      // 分▲▲
      aramWork.timemin = (aramWork.timemin + 5) % 60 ;
      dispEditAram(false) ;
    } else
    if (68 <=y && y<92) {
      // 分▲
      aramWork.timemin = (aramWork.timemin + 1) % 60 ;
      dispEditAram(false) ;
    } else
    if (172 <=y && y<196) {
      // 分▼
      aramWork.timemin = (aramWork.timemin + 59) % 60 ;
      dispEditAram(false) ;
    } else
    if (212 <=y && y<236) {
      // 分▼▼
      aramWork.timemin = (aramWork.timemin + 55) % 60 ;
      dispEditAram(false) ;
    }
  }

  if (28<=y && y<52) {
    for (int i=0;i<7;i++) {
      int cxs = 208 + i * (24 + 16) ;
      int cxe = cxs + 24 ;
      if (cxs<=x && x <cxe) {
        aramWork.wday[i] = (aramWork.wday[i] == 0) ? 1: 0 ;
        dispEditAram(false) ;
        break ;      
      }
    }
  }

  return 0 ;
}
