#ifndef ARAM_H
#define ARAM_H
#include "property.h"

// Tempo = 120 BPM
#define SPEAKER_PIN 21

typedef struct melody_s {
  unsigned short int tone;
  unsigned short int length ;
} melody_t ;

// ビックベンの鐘(学校のチャイム)
static melody_t melody1[] = {
    {698,800},{880,800},{784,800},{523,2300},{0,100},
    {698,800},{784,800},{880,800},{698,2300},{0,100},
    {880,800},{698,800},{784,800},{523,2300},{0,100},
    {523,800},{784,800},{880,800},{698,2300},{0,100},
    {0,0} } ;
// 大盛況(ファミマの音)
static melody_t melody2[] = {
    {740,300},{587,300},{440,300},{587,300},{659,300},{880,800},
    {659,300},{740,300},{659,300},{440,300},{587,300},{0,800},
    {740,300},{587,300},{440,300},{587,300},{659,300},{880,800},
    {659,300},{740,300},{659,300},{440,300},{587,300},{0,0} } ;
// キラキラ星
static melody_t melody3[] = {
    {262,450} ,{0,50}, {262,450},{0,50}, {392,450},{0,50}, {392,450},{0,50}, {440,450},{0,50}, {440,450},{0,50}, 
    {392,1000},{0,50}, {349,450},{0,50}, {349,450},{0,50}, {330,450},{0,50}, {330,450},{0,50}, {294,450},{0,50}, 
    {294,450},{0,50}, {262,500}, {0,0} } ;
//　雨降り
static melody_t melody4[] = {
    {262,250}, {262,250}, {262,250}, {294,250}, 
    {330,250}, {294,250}, {392,250}, {330,250}, 
    {523,250}, {440,250}, {392,250}, {330,250}, {392,500},{0,500},
    {262,250}, {262,250}, {262,250}, {294,250}, 
    {330,250}, {392,250}, {440,250}, {440,250}, 
    {330,250}, {330,250}, {330,250}, {294,250}, {262,500}, {0,500},
    {523,250}, {440,250}, {523,250}, {440,250}, 
    {392,250}, {330,250}, {392,250}, {330,250}, 
    {392,500},{0,50}, {523,500},{0,50}, {523,750}, {0,0} } ;

class ARAM
{
  private:
    ARAM_t aram[5] ;     // アラーム情報
    ARAM_t aramWork ;    // アラーム情報

  public:
    int getAramEnable(int no) { return aram[no].enable ; }      // アラーム有効無効取得
    int getAramTimeHour(int no) { return aram[no].timehour ; }   // アラーム時間 時取得
    int getAramTimeMin(int no) { return aram[no].timemin  ; }     // アラーム時間 分取得
    int getAramMelody(int no) { return aram[no].melody  ; }       // アラームメロディ取得
    int getAramWDay(int no, int wDay) { return aram[no].wday[wDay]; }  // アラーム曜日設定
    void setAramEnable(int no, int en) { aram[no].enable = en ; }        // アラーム有効無効設定
    void setAramTimeHour(int no, int hour) { aram[no].timehour = hour ; }   // アラーム時間 時設定
    void setAramTimeMin(int no, int min) { aram[no].timemin = min ; }       // アラーム時間 分設定
    void setAramMelody(int no, int mel) { aram[no].melody = mel ; }         // アラームメロディ設定
    void setAramWDay(int no, int wDay , int stat) { aram[no].wday[wDay] = stat ; }  // アラーム曜日設定

    void init( ) ;
    void playChime(int chNo) ;
    void dispAramList(bool flagCLS=true);

    void copyAramToWork(int no);
    void copyWorkToAram(int no);
    void dispEditAram(bool flagCLS=true) ;

    int checkMenuTouch(uint16_t x, uint16_t y) ;
    int checkEditMenuTouch(uint16_t x, uint16_t y) ;

} ;

extern ARAM aram ;

#endif
