#include <FS.h>
#include <SD.h>

#include "FontSD.h"
#include "AreaCodeSel.h"
#include "HX8357.h"
#include "debug.h"

#define CENTERS_PATH "/AreaCode/"
#define CENTERS_FILENAME "/AreaCode/centers.json"

AREACODESEL AreaCodeSel ;

void AREACODESEL::clear( ) {
  menuDoc.clear( ) ;
  if (areaCodeList != NULL) {
    delete[] areaCodeList ;
  }
  areaCodeList = NULL ;
  areaCodeListNum = 0 ;
}

bool AREACODESEL::loadCentersJSON( ) {
  menuTitle = "" ;
  menuDoc.clear( ) ;
  if (!SD.exists(CENTERS_FILENAME)) {
    DPRINTF("File Not Exists %s\n",CENTERS_FILENAME) ;
    return false ;
  }  
  // --- File Load ---
  File file = SD.open(CENTERS_FILENAME);
  if (!file) {
    DPRINTF("File OpenError\n") ;
    return false ;
  }

  DeserializationError error = deserializeJson(menuDoc, file);
  file.close();
  if (error) {
    DPRINT(F("deserializeJson() failed: "));
    DPRINTLN(error.f_str());
    return false ;
  }

  // トップレベルのすべてのキー（地方コード）を走査
  for (JsonPair region : menuDoc.as<JsonObject>()) {
    const char* regionCode = region.key().c_str();
    JsonObject regionObj = region.value().as<JsonObject>();

    // 地方名を取得 DEDBUG
    const char* regionName = regionObj["name"];
    DPRINTF("■ 地方コード: %s\n", regionCode);
    DPRINTF("  地方名: %s\n", regionName);

    JsonArray children = regionObj["children"].as<JsonArray>();
    for (JsonObject child : children) {
      const char* childCode = child["code"];
      const char* childName = child["name"];
      DPRINTF("    ├ コード: %s, 名称: %s\n", childCode, childName);
      if (regionCodeSel.compareTo(childCode) == 0) {
        centerCodeSel = regionCode ;
      }
    }
    DPRINTLN();
  }
  DPRINTLN("loadCentersJSON()") ;
  DPRINTF("Selected centerCodeSel=%s\n",centerCodeSel.c_str()) ;
  DPRINTF("Selected regionCodeSel=%s\n",regionCodeSel.c_str()) ;
  DPRINTF("Selected areaCodeSel=%s\n",areaCodeSel.c_str()) ;

  return true ;
}

bool AREACODESEL::makeMenuList(String officeCode) {
  DPRINTF("\nmakeMenuList: officeCode=%s\n",officeCode.c_str()) ;
  menuCur = 0 ;
  int regionCount = 0 ; 
  if (officeCode.length() == 0) {
    menuTitle = "" ;
    areaCodeListNum = 0 ;
    JsonObject root = menuDoc.as<JsonObject>();
    areaCodeListNum = root.size();
    if (areaCodeList != NULL) {
      delete[] areaCodeList ;
    }
    areaCodeList = new areaCodeList_t [areaCodeListNum] ;

    // トップレベルのすべてのキー（地方コード）を走査
    int count = 0 ;
    for (JsonPair region : menuDoc.as<JsonObject>()) {
      const char* regionCode = region.key().c_str();
      JsonObject regionObj = region.value().as<JsonObject>();
  
      const char* regionName = regionObj["name"];
      areaCodeList[count].code = regionCode ;
      areaCodeList[count].name = regionName ;
      count ++ ;
    }
  } else {
    JsonObject regionObj = menuDoc[officeCode].as<JsonObject>();
    const char* regionName = regionObj["name"];
    menuTitle = regionName ;
   
    JsonArray children = regionObj["children"].as<JsonArray>();
    areaCodeListNum = children.size();

    if (areaCodeList != NULL) {
      delete[] areaCodeList ;
    }
    areaCodeList = new areaCodeList_t [areaCodeListNum] ;

    DPRINTF("■ 地方コード: %s\n", officeCode);
    DPRINTF("  地方名: %s\n", regionName);
    int count = 0 ;
    for (JsonObject child : children) {
      const char* childCode = child["code"];
      const char* childName = child["name"];
      DPRINTF("    ├ コード: %s, 名称: %s\n", childCode, childName);

      areaCodeList[count].code = childCode ;
      areaCodeList[count].name = childName ;
      count ++ ;
    }
  }

  for (int i=0;i<areaCodeListNum;i++) {
    DPRINTF("%s : %s\n",areaCodeList[i].code.c_str(),areaCodeList[i].name.c_str()) ;
  }
  
  return true ;
}

bool AREACODESEL::makeCityMenuList(String regionCode) {
  DPRINTF("\nmakeCityMenuList: regionCode=%s\n",regionCode.c_str()) ;

  menuCur = 0 ;
  menuDoc.clear( ) ;
  char fileName[28] ;
  sprintf(fileName,"%s%s.json",CENTERS_PATH,regionCode.c_str() ) ;
  if (!SD.exists(fileName)) {
    DPRINTF("File Not Exists %s\n",fileName) ;
    return false ;
  }  
  // --- File Load ---
  File file = SD.open(fileName);
  if (!file) {
    DPRINTF("File OpenError\n") ;
    return false ;
  }

  DeserializationError error = deserializeJson(menuDoc, file);
  file.close();
  if (error) {
    DPRINT(F("deserializeJson() failed: "));
    DPRINTLN(error.f_str());
    return false ;
  }

  JsonArray array = menuDoc.as<JsonArray>();
  DPRINTF("データ数: %d 件\n", array.size());

  areaCodeListNum = array.size();

  if (areaCodeList != NULL) {
    delete[] areaCodeList ;
  }
  areaCodeList = new areaCodeList_t [areaCodeListNum] ;

  int count = 0 ;
  for (JsonObject item : array) {
//    const char* area = item["areaname"];
    const char* city = item["cityname"];
    const char* code = item["code"];

    areaCodeList[count].code = code ;
    areaCodeList[count].name = city ;
    count ++ ;

    DPRINTF("%s : %s\n", code , city);
  }
  
  return true ;
}

int AREACODESEL::getDefMenuCur(int mode) {
  DPRINTF("\ngetDefMenuCur: mode=%d\n",mode) ;
  int cur = 0 ;
  menuCur = 0 ;
  menuCurTop = 0 ;
  switch(mode) {
  case 1: cur = getDefMenuCur1( ) ; break ;
  case 2: cur = getDefMenuCur2( ) ; break ;
  case 3: cur = getDefMenuCur3( ) ; break ;
  }
  return cur ;
}

int AREACODESEL::getDefMenuCur1( ) {
  DPRINTF("\ngetDefMenuCur1 : code=%s\n",centerCodeSel.c_str()) ;
  for (JsonPair region : menuDoc.as<JsonObject>()) {
    const char* regionCode = region.key().c_str();
    // 地方名を取得 DEDBUG
    JsonObject regionObj = region.value().as<JsonObject>();
    const char* regionName = regionObj["name"];
    DPRINTF("Checking RegionCode=%s  regionName=%s\n",regionCode,regionName) ;

    if (centerCodeSel.compareTo(regionCode) == 0) {
      if (menuCur > menuItemNum) {
        menuCurTop = menuCur ;
        menuCur = 0 ;
      }
      DPRINTF("Found RegionCode=%s  menuCur=%d\n",regionCode,menuCur) ;
      return menuCur ;
    }
    menuCur ++ ;
  }
  return 0 ;
}

int AREACODESEL::getDefMenuCur2( ) {
  DPRINTF("\ngetDefMenuCur2 : code=%s\n",regionCodeSel.c_str()) ;
  JsonObject regionObj = menuDoc[centerCodeSel].as<JsonObject>();

  // 地方名を取得 DEDBUG
  const char* regionName = regionObj["name"];
  DPRINTF("■ 地方コード: %s\n", regionCodeSel.c_str());
  DPRINTF("  地方名: %s\n", regionName);

  JsonArray children = regionObj["children"].as<JsonArray>();
  for (JsonObject child : children) {
    const char* childCode = child["code"];
    const char* childName = child["name"];
    DPRINTF("    ├ コード: %s, 名称: %s\n", childCode, childName);
    if (regionCodeSel.compareTo(childCode)==0) {
      if (menuCur > menuItemNum) {
        menuCurTop = menuCur ;
        menuCur = 0 ;
      }
      DPRINTF("Found RegionCode=%s  menuCur=%d\n",childCode,menuCur) ;
      return menuCur ;
    }
    menuCur ++ ;
  }
  menuCur = 0 ;
  DPRINTF("menuCur=%d not found\n",menuCur) ;

  return 0 ;
}

int AREACODESEL::getDefMenuCur3( ) {
  DPRINTF("\getDefMenuCurArea : regionCodeSel=%s  areaCodeSel=%s  CityNameSel=%s\n",regionCodeSel.c_str(),areaCodeSel.c_str(),CityNameSel.c_str() ) ;
  for (menuCur = 0 ; menuCur < areaCodeListNum ; menuCur++) {
    DPRINTF("code=%s  name=%s\n",areaCodeList[menuCur].code.c_str(),areaCodeList[menuCur].name.c_str()) ;
    if (areaCodeSel == areaCodeList[menuCur].code && CityNameSel == areaCodeList[menuCur].name) {
      menuCurTop = (menuCur / menuItemNum) * menuItemNum ;
      menuCur = menuCur - menuCurTop ;
      DPRINTF("Found AreaCode=%s  menuCur=%d\n",areaCodeSel.c_str(),menuCur) ;
      return menuCur ;
    }
  }

  menuCur = 0 ;
  DPRINTF("menuCur=%d not found\n",menuCur) ;
  return 0 ;
}

bool AREACODESEL::dispMenu( ) {
  tft.fillScreen(COLOR_BLACK);

  int posY = 4 ;
  int num = 0 ;

  DPRINTF("\ndispMenu: cur=%d\n",menuCur) ;
  if (menuTitle.length() != 0) {
    char str[64] ;
    sprintf(str,"【%s】",menuTitle.c_str());
    fontSD.dispTextG(8 , posY , 276 , str , COLOR_GREEN) ;
  }
  posY += 20 ;
  if (menuCurTop > 0) {
    fontSD.dispTextG(24 , posY , 16 , "▲", COLOR_GREEN) ;
    posY += 20 ;
  }
  int curMax = areaCodeListNum - menuCurTop ;
  if (curMax > menuItemNum) curMax = menuItemNum ;
  for (num=0;num<curMax;num++) {
    uint16_t fColor = COLOR_WHITE ;
    if (num == menuCur) {
      fColor = COLOR_CYAN ;
      fontSD.dispTextG(2 , posY , 296 , "◆", fColor) ;
    }
    fontSD.dispTextG(24 , posY , 296 , (char *)areaCodeList[num+menuCurTop].name.c_str(),fColor) ;
    posY += 20 ;
  }
  if (menuCurTop + menuItemNum < areaCodeListNum) {
    fontSD.dispTextG(24 , posY , 16 , "▼", COLOR_GREEN) ;
  }
  dispMenuControl( ) ;

  return true ;
}

void AREACODESEL::dispMenuControl( ) {
  tft.fillBox(340 ,8,136,48,COLOR_BLUE) ;
  tft.fillBox(342,10,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(392 , 18 , 128 , "▲", COLOR_BLACK,COLOR_WHITE,false,true) ;
  tft.fillBox(340,80,136,48,COLOR_BLUE) ;
  tft.fillBox(342,82,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(392, 90 , 128 , "▼", COLOR_BLACK,COLOR_WHITE,false,true) ;
  tft.fillBox(340,172,136,48,COLOR_BLUE) ;
  tft.fillBox(342,174,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(376 , 182 , 128 , "決定", COLOR_BLACK,COLOR_WHITE,false,true) ;
  tft.fillBox(340,244,136,48,COLOR_BLUE) ;
  tft.fillBox(342,246,132,44,COLOR_WHITE) ;
  fontSD.dispTextG(376 , 254 , 128 , "戻る", COLOR_BLACK,COLOR_WHITE,false,true) ;
}

int AREACODESEL::checkMenuTouch(uint16_t x, uint16_t y) {
  if (340<=x&&x<476 && 8<=y&&y<56) {
    // ▲
    return -1 ;
  } else
  if (340<=x&&x<476 && 80<=y&&y<128) {
    // ▼
    return 1 ;
  } else
  if (340<=x&&x<476 && 172<=y&&y<220) {
    // 決定
    return 2 ;
  } else
  if (340<=x&&x<476 && 244<=y&&y<292) {
    // 戻る
    return 3 ;
  }
  return 0 ;
}

bool AREACODESEL::moveCursor(int move) {
  // move ±1
  int posY = 4 +menuCur * 20 + 20 ;
  if (menuCurTop > 0) { posY += 20 ; }
  bool flagPrevPage = (menuCurTop > 0) ? true : false ;
  bool flagNextPage = (menuCurTop + menuItemNum < areaCodeListNum) ? true : false ;
  int curMax = areaCodeListNum - menuCurTop - 1 ;
  if (curMax > menuItemNum) { curMax = menuItemNum ; }
  DPRINTF("menuCurTop=%d curMax=%d menuCur=%d move=%d\n",menuCurTop,curMax,menuCur,move) ;

  fontSD.dispTextG(2 , posY , 296 , "◆" , COLOR_BLACK) ;
  fontSD.dispTextG(24 , posY , 296 , (char *)areaCodeList[menuCurTop+menuCur].name.c_str(),COLOR_WHITE) ;
  menuCur += move ;
  
  if (flagPrevPage && menuCur < 0) {
    menuCur = menuItemNum - 1;
    menuCurTop -= menuItemNum ;
    if (menuCurTop < 0) menuCurTop = 0 ;       
    dispMenu( ) ;
    return true ;
  }
  if (flagNextPage && menuCur >= menuItemNum) {
    menuCur = 0 ;
    menuCurTop += menuItemNum ;
    dispMenu( ) ;
    return true ;
  }

  if (menuCur < 0) { menuCur = 0 ;}
  if (menuCur > curMax) { menuCur = curMax ; }
  posY = 4 + menuCur * 20 + 20 ;
  if (menuCurTop > 0) { posY += 20 ; }
  fontSD.dispTextG(2 , posY , 296 , "◆", COLOR_CYAN) ;
  fontSD.dispTextG(24 , posY , 296 , (char *)areaCodeList[menuCurTop+menuCur].name.c_str(),COLOR_CYAN) ;
  return true ;
}

String AREACODESEL::getCode(int mode) {
  int count =  menuCur + menuCurTop ;
  switch(mode) {
  case 1: centerCodeSel = areaCodeList[count].code ;
    menuTitle = areaCodeList[count].name ;
    DPRINTF("centerCode=%s\n",centerCodeSel.c_str() ) ;
    break ;
  case 2: regionCodeSel = areaCodeList[count].code ;
    regionNameSel = areaCodeList[count].name ;
    menuTitle = regionNameSel ; 
    DPRINTF("regionName=%s\n",regionNameSel.c_str() ) ;
    break ;
  case 3: areaCodeSel = areaCodeList[count].code ;
    CityNameSel = areaCodeList[count].name ;
    DPRINTF("CityName=%s\n",CityNameSel.c_str() ) ;
    break ;
  default: menuTitle = "" ;
  }
  return areaCodeList[count].code ;
}
