#ifndef AREACODESEL_H
#define AREACODESEL_H

#include <ArduinoJson.h>

typedef struct areaCodeList_s {
  String code ;
  String name ;  
} areaCodeList_t ;

class AREACODESEL
{
  private:
    JsonDocument menuDoc;
    int areaCodeListNum = 0 ;
    areaCodeList_t *areaCodeList = NULL ;
    
    int menuCur = 0 ;
    int menuCurTop = 0 ;
    const int menuItemNum = 13 ;
    String menuTitle = "" ;

    String centerCodeSel ;
    String regionCodeSel ;
    String areaCodeSel ;

    String regionNameSel ;
    String CityNameSel ;

  public:
    void setRegionCode(String regionCode) { regionCodeSel = regionCode ; }
    void setAreaCode(int areaCode) { areaCodeSel = String(areaCode) ; }
    void setCityName(String cityName) { CityNameSel = cityName ; }
    String getCenterCode( ) { return centerCodeSel ; }
    String getRegionCode( ) { return regionCodeSel ; }
    String getAreaCode( ) { return areaCodeSel ; }
    String getRegionName( ) { return regionNameSel ; }
    String getCityName( ) { return CityNameSel ; }  

    void clear( ) ;
    bool loadCentersJSON() ;
    bool makeMenuList(String officeCode) ;
    bool makeCityMenuList(String regionCode) ;
    bool dispMenu() ;
    bool moveCursor(int move) ;
    String getCode(int mode) ;
    int getDefMenuCur(int mode) ;
    int getDefMenuCur1( ) ;
    int getDefMenuCur2( ) ;
    int getDefMenuCur3( ) ;
    void dispMenuControl( ) ;
    int checkMenuTouch(uint16_t x, uint16_t y) ;

} ;

extern AREACODESEL AreaCodeSel ;

#endif
