#ifndef _BME280_
#define _BME280_

#include <Wire.h>

/** BME280 I2Cアドレス */
#define BME280_ADDR 0x76

// TWELITEとBME280の計測結果の差異を補正するオフセット
#define TWERIT_DEFF_T -5.0
#define TWERIT_DEFF_H 18.1

class BME280 {
  private:
    // キャリブレーションデータ
    uint16_t dig_T1;
    int16_t  dig_T2, dig_T3;
    
    uint16_t dig_P1;
    int16_t  dig_P2, dig_P3, dig_P4, dig_P5, dig_P6, dig_P7, dig_P8, dig_P9;
    
    uint8_t  dig_H1, dig_H3;
    int16_t  dig_H2, dig_H4, dig_H5;
    int8_t   dig_H6;
    
    int32_t t_fine;
    /**< @brief 1バイト読み込み */
    uint8_t read8(uint8_t reg) ;
    /**< @brief 2バイト読み込み */
    uint16_t read16(uint8_t reg) ;
    /**< @brief 2バイト読み込み（符号付き） */
    int16_t readS16(uint8_t reg) ;
    /**< @brief 1バイト書き込み */
    void write8(uint8_t reg, uint8_t val) ;
    /**< @brief キャリブレーションデータ読み込み */
    void readCalibrationData() ;
    /**< @brief 生データ読み込み */
    void readRawData(int32_t &adc_T, int32_t &adc_P, int32_t &adc_H) ;
    /**< @brief 温度補正計算 */
    float compensateTemperature(int32_t adc_T) ;
    /**< @brief 気圧補正計算 */
    float compensatePressure(int32_t adc_P) ;
    /**< @brief 湿度補正計算 */
    float compensateHumidity(int32_t adc_H) ;

  public:
    /**< @brief BME280初期化 */
    void initBME280() ;
    /**< @brief 補正済み環境値取得 */
    void getCompensate(float &temp , float &pres , float &hum) ;

} ;

extern BME280 bme ;

#endif
