/*
 * SSD1306/SSD1315に７セグメントっぽいフォントで表示用のクラスを流用
 * HX8357用にビットマップデータを256色用に変換して返す
 * 
 */
#ifndef DISP7SEG_H
#define DISP7SEG_H
#include <arduino.h>
#include <time.h>

// CONFIGアイコンの番号定義
#define WIFI_ICON 1
#define CONFIG_ICON 2
#define ALARM_ICON 3
#define LAUNDRY_ICON 4
#define AirPressure 5

class DISP7SEG
{
  private:
    uint8_t bitMapBuff[21*4];     // 7セグっぽいフォントの合成用バッファ
    uint16_t bitMap7Seg[64*64];   // 7セグっぽいフォントのBitMapData:16*32からWiFiイメージ表示対応の為に拡張
    char strBuff[24] ; ;          // 文字列変換用バッファ
    int char2num(char c) ;        // 文字を7セグメント用の数値に変換

  public:
    /**@brief 7セグメント用フォント取得  */
    uint16_t *disp7SEG(int num,uint16_t colorF,uint16_t colorB);
    /**@brief 日時表示 */
    void dispTime(int x, int y ,int year , int mon,int mday , int hour , int tm_min , int tm_sec , uint16_t colorF, uint16_t colorB) ;
    /**@brief 日付表示 */
    int dispDate(int x, int y ,int year , int mday , int hour , uint16_t colorF, uint16_t colorB) ;
    /**@brief 時刻表示 */
    int dispTime(int x, int y ,int hour , int tm_min , int tm_sec , uint16_t colorF, uint16_t colorB) ;
    /**@brief アイコン表示 */  
    void dispIcon(int x, int y , int iconNo , uint16_t colorF,uint16_t colorB) ;
    /**@brief 補正済み環境値表示 */
    int dispCompensate(int x, int y , int statType , float stat , uint16_t colorF , uint16_t colorB);
} ;

extern DISP7SEG disp7seg ;

#endif
