/*
 * SDカードから東雲フォントを読み出して表示するクラス
 * 
 */

#ifndef _FONTSD_
#define _FONTSD_

#include <FS.h>
#include "HX8357.h"

#define BITREVERS false  // M5.Lcd.drawXBitmap()用にBIT並びを逆転したファイルを使用する場合
#if BITREVERS // 東雲フォント（ビット反転版）を使用
#define FONT_FILE "/SINONOME_FONT_R.BIN"
#else
#define FONT_FILE "/SINONOME_FONT.BIN"
#endif

#define FONT_SIZE_H 16  // 8x16フォントサイズ
#define FONT_SIZE_F 32  // 16x16フォントサイズ

#define FONT16WIDTH 8   // 16x16フォント横幅
#define FONT32WIDTH 16  // 32x16フォント横幅
#define FONT_HIGHT  16  // フォント高さ

#define DISP_HIGHT 320  // 画面高さ

class FontSD {
  private:
    File fontFile ; // フォントファイルオブジェクト
    uint8_t fontdata[FONT_SIZE_F] ; // フォントデータ格納バッファ

    // --- 東雲フォント読み出し
    bool openSD() ;
    void closeSD() ;
    int UTF8LEN(uint8_t *utf8codes) ; // UTF-8文字列のバイト長取得
    uint8_t utf16_to_jis_kana(uint16_t utf16_char) ;  // UTF-16半角カナをJIS X 0201に変換
    uint16_t UTF8ToUTF16(uint8_t *utf8codes) ;  // UTF8->UTF16
    uint8_t reverse_bits(uint8_t value) ; // 8ビットのビット順を逆にする関数
    uint8_t* readFont16x16(uint16_t code) ; // 16x16フォントデータ読み出し
    uint8_t* readFont8x16(uint8_t code) ; // 8x16フォントデータ読み出し

    // --- 文字表示
    int curX ;  // 現在表示X座標
    int curY ;  // 現在表示Y座標
    int curW ;  // 表示幅
    int curTop; // 表示開始X座標
    void disp32G(uint16_t code,uint16_t colorF=COLOR_WHITE, uint16_t colorB=COLOR_BLACK, bool blankSkip=false, bool doubleSize=false) ;  // 32x16フォントで文字を表示
    void disp16G(uint8_t code,uint16_t colorF=COLOR_WHITE,uint16_t colorB=COLOR_BLACK, bool blankSkip=false, bool doubleSize=false) ; // 16x16フォントで文字を表示

  public:
    bool dispTextG(int x, int y, int w, char *text, uint16_t colorF=COLOR_WHITE ,uint16_t colorB=COLOR_BLACK, bool blankSkip=false, bool doubleSize=false) ;  // 文字列を表示（色指定付き）
} ;

extern FontSD fontSD ;

#endif
