/** 画像表示関数群
 * 
 */

#ifndef IMAGEDISP_H
#define IMAGEDISP_H
#include "ImageData.h"

bool LoadWatherIcon(int watherCode, int x, int y, bool flagNight);
void margeIcon(uint16_t *baseIcon,uint16_t *watherIcon,int width,int hight) ;
void margeFrame(uint16_t *baseIcon,uint16_t *watherIcon,int width,int hight,uint16_t frameColor) ;
bool LoadImage(char *fileName,IMAGEDATA *imageData) ;

// WatherCOdeと表示アイコンの対応::夜アイコンは使用しないかも
static struct watherCode2Icon_s {
  int watherCode ;  // 気象コード
  int iconDay ;     // 昼間アイコン番号
  int iconNight ;   // 夜間アイコン番号
  char *wather ;    // 天気名称
} watherCode2Icon[] = {
  {100,100,500,"晴"              },
  {101,101,501,"晴時々曇"        },
  {102,102,502,"晴一時雨"        },
  {103,102,502,"晴時々雨"        },
  {104,104,504,"晴一時雪"        },
  {105,104,504,"晴時々雪"        },
  {106,102,502,"晴一時雨か雪"    },
  {107,102,502,"晴時々雨か雪"    },
  {108,102,502,"晴一時雨か雷雨"  },
  {110,110,510,"晴後時々曇"      },
  {111,110,510,"晴後曇"          },
  {112,112,512,"晴後一時雨"      },
  {113,112,512,"晴後時々雨"      },
  {114,112,512,"晴後雨"          },
  {115,115,515,"晴後一時雪"      },
  {116,115,515,"晴後時々雪"      },
  {117,115,515,"晴後雪"          },
  {118,112,512,"晴後雨か雪"      },
  {119,112,512,"晴後雨か雷雨"    },
  {120,102,502,"晴朝夕一時雨"    },
  {121,102,502,"晴朝の内一時雨"  },
  {122,112,512,"晴夕方一時雨"    },
  {123,100,500,"晴山沿い雷雨"    },
  {124,100,500,"晴山沿い雪"      },
  {125,112,512,"晴午後は雷雨"    },
  {126,112,512,"晴昼頃から雨"    },
  {127,112,512,"晴夕方から雨"    },
  {128,112,512,"晴夜は雨"        },
  {130,100,500,"朝の内霧後晴"    },
  {131,100,500,"晴明け方霧"      },
  {132,101,501,"晴朝夕曇"        },
  {140,102,502,"晴時々雨で雷を伴う"},
  {160,104,504,"晴一時雪か雨"    },
  {170,104,504,"晴時々雪か雨"    },
  {181,115,515,"晴後雪か雨"      },
  {200,200,200,"曇"              },
  {201,201,601,"曇時々晴"        },
  {202,202,202,"曇一時雨"        },
  {203,202,202,"曇時々雨"        },
  {204,204,204,"曇一時雪"        },
  {205,204,204,"曇時々雪"        },
  {206,202,202,"曇一時雨か雪"    },
  {207,202,202,"曇時々雨か雪"    },
  {208,202,202,"曇一時雨か雷雨"  },
  {209,200,200,"霧"              },
  {210,210,610,"曇後時々晴"      },
  {211,210,610,"曇後晴"          },
  {212,212,212,"曇後一時雨"      },
  {213,212,212,"曇後時々雨"      },
  {214,212,212,"曇後雨"          },
  {215,215,215,"曇後一時雪"      },
  {216,215,215,"曇後時々雪"      },
  {217,215,215,"曇後雪"          },
  {218,212,212,"曇後雨か雪"      },
  {219,212,212,"曇後雨か雷雨"    },
  {220,202,202,"曇朝夕一時雨"    },
  {221,202,202,"曇朝の内一時雨"  },
  {222,212,212,"曇夕方一時雨"    },
  {223,201,601,"曇日中時々晴"    },
  {224,212,212,"曇昼頃から雨"    },
  {225,212,212,"曇夕方から雨"    },
  {226,212,212,"曇夜は雨"        },
  {228,215,215,"曇昼頃から雪"    },
  {229,215,215,"曇夕方から雪"    },
  {230,215,215,"曇夜は雪"        },
  {231,200,200,"曇海上海岸は霧か霧雨"},
  {240,202,202,"曇時々雨で雷を伴う"},
  {250,204,204,"曇時々雪で雷を伴う"},
  {260,204,204,"曇一時雪か雨"    },
  {270,204,204,"曇時々雪か雨"    },
  {281,215,215,"曇後雪か雨"      },
  {300,300,300,"雨"              },
  {301,301,701,"雨時々晴"        },
  {302,302,302,"雨時々止む"      },
  {303,303,303,"雨時々雪"        },
  {304,300,300,"雨か雪"          },
  {306,300,300,"大雨"            },
  {308,308,308,"雨で暴風を伴う"  },
  {309,303,303,"雨一時雪"        },
  {311,311,711,"雨後晴"          },
  {313,313,313,"雨後曇"          },
  {314,314,314,"雨後時々雪"      },
  {315,314,314,"雨後雪"          },
  {316,311,711,"雨か雪後晴"      },
  {317,313,313,"雨か雪後曇"      },
  {320,311,711,"朝の内雨後晴"    },
  {321,313,313,"朝の内雨後曇"    },
  {322,303,303,"雨朝晩一時雪"    },
  {323,311,711,"雨昼頃から晴"    },
  {324,311,711,"雨夕方から晴"    },
  {325,311,711,"雨夜は晴"        },
  {326,314,314,"雨夕方から雪"    },
  {327,314,314,"雨夜は雪"        },
  {328,300,300,"雨一時強く降る"  },
  {329,300,300,"雨一時みぞれ"    },
  {340,400,400,"雪か雨"          },
  {350,300,300,"雨で雷を伴"      },
  {361,411,811,"雪か雨後晴"      },
  {371,413,413,"雪か雨後曇"      },
  {400,400,400,"雪"              },
  {401,401,801,"雪時々晴"        },
  {402,402,402,"雪時々止む"      },
  {403,403,403,"雪時々雨"        },
  {405,400,400,"大雪"            },
  {406,406,406,"風雪強い"        },
  {407,406,406,"暴風雪"          },
  {409,403,403,"雪一時雨"        },
  {411,411,811,"雪後晴"          },
  {413,413,413,"雪後曇"          },
  {414,414,414,"雪後雨"          },
  {420,411,811,"朝の内雪後晴"    },
  {421,413,413,"朝の内雪後曇"    },
  {422,414,414,"雪昼頃から雨"    },
  {423,414,414,"雪夕方から雨"    },
  {425,400,400,"雪一時強く降る"  },
  {426,400,400,"雪後みぞれ"      },
  {427,400,400,"雪一時みぞれ"    },
  {450,400,400,"雪で雷を伴う"    },
  {0, 0 ,0,""},  // EOF
};

static struct watherIcon_s {
  int iconNo ;
  uint8_t icon[3] ;
} watherIcon[] = {
  {100 , 1 , 0  , 0 } , // 晴れ
  {101 , 1 , 2  , 0 } , // 晴れ　時々　曇
  {102 , 1 , 3  , 0 } , // 晴れ　一時　雨
  {104 , 1 , 4  , 0 } , // 晴れ　一時　雪
  {110 , 1 , 2  , 1 } , // 晴れ　後時々　曇
  {112 , 1 , 3  , 1 } , // 晴れ　後一時　雨
  {115 , 1 , 4  , 1 } , // 晴れ　後一時　雪
  {200 , 2 , 0  , 0 } , // 雲り
  {201 , 2 , 1  , 0 } , // 雲り　時々　晴れ
  {202 , 2 , 3  , 0 } , // 雲り　時々　雨
  {204 , 2 , 4  , 0 } , // 雲り　時々　雪
  {210 , 2 , 1  , 1 } , // 雲り　のち　晴れ
  {211 , 2 , 1  , 1 } , // 雲り　のち　晴れ
  {212 , 2 , 3  , 1 } , // 雲り　のち　雨
  {215 , 2 , 4  , 1 } , // 雲り　のち　雪
  {300 , 3 , 0  , 0 } , // 雨
  {301 , 3 , 1  , 0 } , // 雨　時々　晴れ
  {302 , 3 , 2  , 0 } , // 雨　時々　曇り
  {303 , 3 , 4  , 0 } , // 雨　時々　雪
  {308 , 5 , 0  , 0 } , // 暴風雨★
  {311 , 3 , 1  , 1 } , // 雨　のち　晴れ
  {313 , 3 , 2  , 1 } , // 雨　のち　曇り
  {314 , 3 , 4  , 1 } , // 雨　のち　雪
  {400 , 4 , 0  , 0 } , // 雪
  {401 , 4 , 1  , 0 } , // 雪　時々　晴れ
  {401 , 4 , 2  , 0 } , // 雪　時々　曇り
  {401 , 4 , 3  , 0 } , // 雪　時々　雨
  {406 , 6 , 0  , 0 } , // 暴風雪
  {411 , 4 , 1  , 1 } , // 雪　のち　晴れ
  {413 , 4 , 2  , 1 } , // 雪　のち　曇り
  {414 , 4 , 3  , 1 } , // 雪　のち　雨
  // --- 夜
  {500 , 1 , 0  , 0 } , // 晴れ
  {501 , 1 , 2  , 0 } , // 晴れ　時々　曇り
  {502 , 1 , 3  , 0 } , // 晴れ　時々　雨
  {504 , 1 , 4  , 0 } , // 晴れ　時々　雪
  {510 , 1 , 2  , 1 } , // 晴れ　のち　曇り
  {512 , 1 , 3  , 1 } , // 晴れ　のち　雨
  {515 , 1 , 4  , 1 } , // 晴れ　のち　雪
  {601 , 2 , 1  , 0 } , // 雲り　時々　晴れ
  {610 , 2 , 1  , 1 } , // 雲り　のち　晴れ
  {701 , 3 , 1  , 0 } , // 雨　時々　晴れ
  {711 , 3 , 1  , 1 } , // 雨　のち　晴れ
  {801 , 4 , 1  , 0 } , // 雪　時々　晴れ
  {811 , 4 , 1  , 1 } , // 雪　のち　晴れ
  {0 , 0 , 0  , 0 } , // EOF
  } ;

#endif
