/*
 * OpenWatheMap お天気データ取得
 * * 
 */
#ifndef _OPENWATHER_H_
#define _OPENWATHER_H_

#define WATHEDATA_NUM 2
#define WATHE_LEN 128

typedef struct WatherTime_s {
  int tm_year;  // 年 + 1900
  int tm_mon;   // 月 - 1 (0-11)
  int tm_mday;  // 日 (1-31)
  int tm_hour;  // 時 (0-23)
  int tm_min;   // 分 (0-59)
  int tm_sec;   // 秒 (0-59)
} WatherTime_t ;

typedef struct WatherData_s {
  WatherTime_t watherTime ;   // 予報日時
  int watherCode ;            // 天気コード
  char wather[WATHE_LEN] ;    // 天気概要
  int pops[4] ;               // 降水確率（朝・昼・夕・夜）
} WatherData_t ;

class JMAWATHER
{
  private:
    /* 天気予報データ取得用内部関数 */
    void readWatherData(String watherDataStr,int areaCode) ;
    /* 日付文字列をWatherTime_t形式に変換 */
    WatherTime_t dateFormat(String dateStr) ;
    /* UTF-8文字列のバイト長を取得 */
    int UTF8LEN(uint8_t *utf8codes) ;
    /* JString文字列をC文字列にコピー */
    int copyJString(char *dst , const char *src , int maxLen=WATHE_LEN) ;

  public:
    struct tm ntpTime ;                     // NTP取得時刻
    char publishingOffice[WATHE_LEN] ;      // 発表機関名
    char areaName[WATHE_LEN] ;              // 地域名
    WatherData_t watheData[WATHEDATA_NUM] ; // 天気予報データ

    void initWatherData( ) ;  // 天気予報データ初期化
    bool getWatherData( ) ;   // 天気予報データ取得

    bool connectWiFi( ) ; // WiFi接続
    bool getNTP( ) ;      // NTPサーバーから時刻取得

} ;

extern JMAWATHER jmaWather ;
#endif
