#include <Arduino.h>
#include "SDCard.h"
#include "debug.h"
#include "SD.h"

/**
 * @brief SDカードを初期化する
 * 
 * @param csPin CSピン番号
 */
void initSDCard(int csPin) {
  if(!SD.begin(csPin , SPI , 25000000)) { // ESP32 requires 25 MHz limit
    DPRINTLN("SD mount failed");
    return;
  }
  DPRINTLN("SD mounted OK.");
}
