/* TWELITE PAL 環境センサー通信 */
#ifndef _TWELITE_
#define _TWELITE_

// TWELITE PAL 環境センサー関連定義
#define PALNUM 2    // PAL数
#define PAL1 0      // PAL1
#define PAL2 1      // PAL2
#define READ_DATA_LEN 50  // 受信データ最大バイト数
#define TWELITE_RX 16     // RX ピン
#define TWELITE_TX 17     // TX ピン

typedef struct TwelitePalEnv_s {  // TWELITE PAL　環境センサーからの情報保持用
  uint8_t devId ;         // デバイスID
  uint8_t serialNo[4];    // 固有ID
  uint8_t lqi ;           // 電波強度
  uint16_t volt ;         // 電源電圧
  int16_t temperature ;   // 気温
  uint16_t humidity ;     // 気圧
  int32_t brightness;     // 明るさ
} TwelitePalEnv_t ;

class TWELITE {
  private:
    uint8_t readData[READ_DATA_LEN];  // バイナリー形式の受信データ
    int  recvLen ;    // 受信したデータのバイト数
    bool recvFlag ;   // 受信中フラグ
    bool recvMSB ;    // 受信MSBフラグ

    void hexCharaSet(uint8_t data,char *buffPos) ;  // １Byteのデータを16進数2文字のASCII文字列に変換
    uint8_t hex2Bin(char c) ;  // 16進数1桁のASCII文字を数値に変換
    int readDataDecode(int dataLen , uint8_t *sensorData) ;  // TWELITE PAL 環境センサーからの受信データをデコード

  public:
    TwelitePalEnv_t twelitePalEnv[PALNUM] ; // TWELITE PAL 環境センサー情報

    TWELITE() ;
    void init( ) ;   // TWELITE シリアル通信初期化
    int readSerial( ) ;  // TWELITE シリアルデータ受信処理

    int getDevId(int PalNo) ;         // 送信デバイスID
    int getLqi(int PalNo) ;           // 電波強度
    float getVolt(int PalNo) ;        // 電源電圧
    int getBrightness(int PalNo) ;    // 明るさ
    float getTemperature(int PalNo) ; // 温度
    float getHumidity(int PalNo) ;    // 湿度
} ;

extern TWELITE twelite ;
#endif
