// 7セグメント表示用マップ
// 2値ビットマップ形式のデータ
// ７セグメント調表示用とCONFIGアイコン用ではビットの並びが違うので注意

// セグメントビットマップ用ビットマスク ※SSD1306用に作成
static uint8_t mcbp[] = { 0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80 } ;

static bool addMap[][7] = {
  true , true , true , true , true , true , false,  // 0
  false, true , true , false, false, false, false,  // 1
  true , true , false, true , true , false, true ,  // 2
  true , true , true , true , false, false, true ,  // 3
  false, true , true , false, false, true , true ,  // 4
  true , false, true , true , false, true , true ,  // 5
  true , false, true , true , true , true , true ,  // 6
  true , true , true , false, false, false, false,  // 7
  true , true , true , true , true , true , true ,  // 8
  true , true , true , true , false, true , true ,  // 9
  false, false, false, false, false, false, true ,  // -
} ;

static int base7SEG_W=16 , base7SEG_H=32;
static uint8_t base7SEG[] = {
  0xFC,0x02,0x05,0x09,0xF1,0x11,0x11,0x11,0x11,0x11,0xF1,0x09,0x05,0x02,0xFC,0x00,
  0x7F,0x80,0x80,0x40,0x3F,0x20,0x20,0x20,0x20,0x20,0x3F,0x40,0x80,0x80,0x7F,0x00,
  0xFF,0x00,0x00,0x01,0xFE,0x02,0x02,0x02,0x02,0x02,0xFE,0x01,0x00,0x00,0xFF,0x00,
  0x1F,0x20,0x50,0x48,0x47,0x44,0x44,0x44,0x44,0x44,0x47,0x48,0x50,0x20,0x1F,0x00
};

// a
static int SEGa_W=16 , SEGa_H=32;
static uint8_t SEGa[] = {
  0x00,0x00,0x02,0x06,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x0E,0x06,0x02,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// b
static int SEGb_W=16 , SEGb_H=32;
static uint8_t SEGb[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0xF8,0xFC,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x7F,0x7F,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// c
static int SEGc_W=16 , SEGc_H=32;
static uint8_t SEGc[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0xFF,0xFF,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x0F,0x1F,0x00,0x00,
};

// d
static int SEGd_W=16 , SEGd_H=32;
static uint8_t SEGd[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x20,0x30,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x30,0x20,0x00,0x00,0x00,
};

// e
static int SEGe_W=16 , SEGe_H=32;
static uint8_t SEGe[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xFF,0xFF,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x1F,0x0F,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// f
static int SEGf_W=16 , SEGf_H=32;
static uint8_t SEGf[] = {
  0x00,0xFC,0xF8,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x7F,0x7F,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// g
static int SEGg_W=16 , SEGg_H=32;
static uint8_t SEGg[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x80,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0x80,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// dot
static int SEGdot_W=16 , SEGdot_H=32;
static uint8_t SEGdot[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x3C,0x7E,0x7E,0x7E,0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
};

// Temp
static int SEGtemp_W=16 , SEGtemp_H=32;
static uint8_t SEGtemp[] = {
  0x00,0x00,0x00,0xF8,0x04,0xF2,0xFA,0xBA,0xB2,0x04,0xF8,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0xFF,0x00,0xFF,0xFF,0x6D,0x6D,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0xF0,0x08,0xC4,0xE7,0xF0,0xFF,0xFF,0xFF,0xFF,0xF0,0xE7,0xC4,0x08,0xF0,0x00,0x00,
  0x1F,0x20,0x47,0x4F,0x5F,0x5F,0x5F,0x5F,0x5F,0x5F,0x4F,0x47,0x20,0x1F,0x00,0x00,
} ;

// ℃
static int SEGoc_W=16 , SEGtoc_H =32;
static uint8_t SEGoc[] = {
  0x00,0x80,0x40,0x20,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x04,0xF2,0xF9,0x1C,0x0C,0x0C,0x0C,0x0C,0x0C,0x1C,0xF8,0xF0,0x00,
  0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x00,
  0x00,0x00,0x00,0x00,0x07,0x0F,0x1C,0x18,0x18,0x18,0x18,0x18,0x1C,0x0F,0x07,0x00,
} ;

// 湿度計
static int SEGhum_W=16 , SEGthum_H=32;
static uint8_t SEGhum[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0xC0,0xF8,0xC0,0x00,0xA8,0xA8,0xA8,0xA8,0xA8,0x00,
  0x00,0x00,0x00,0x80,0xF0,0xFE,0xFF,0xFF,0xFF,0xFE,0xF0,0x82,0x02,0x02,0x02,0x00,
  0x00,0xF8,0xFE,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFE,0xF8,0x00,0x00,
  0x00,0x07,0x1F,0x3F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x7F,0x3F,0x1F,0x07,0x00,0x00,
} ;

// %
static int SEGp_W=16 , SEGtp_H=32;
static uint8_t SEGp[] = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0xC0,0x20,0x10,0x20,0xC0,0x00,0x00,0xC0,0xF0,0x7C,0x0C,0x00,0x00,0x00,0x00,
  0x00,0x00,0x01,0x02,0x01,0xC0,0xF8,0x3E,0x0F,0x01,0x00,0x00,0x80,0x00,0x00,0x00,
  0x00,0x00,0x18,0x1C,0x0F,0x03,0x00,0x00,0x00,0x00,0x06,0x09,0x10,0x09,0x06,0x00,
} ;

// Presser
static int SEGPress_W=16 , SEGPress_H=32;
static uint8_t SEGPress[]  = {
  0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,
  0x70,0x8C,0x00,0x80,0x7F,0x00,0x00,0xFF,0x00,0x00,0x7F,0x80,0x00,0x8C,0x70,0x00,
  0x10,0x10,0x11,0x10,0x10,0x10,0x10,0x11,0x10,0x10,0x10,0x10,0x11,0x10,0x10,0x00
} ;

static int SEGhpa_W=21 , SEGhpa_H=32;
static uint8_t SEGhpa[]  = {
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0xF8,0x08,0x08,0x08,0x10,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0xFF,0x10,0x08,0x08,0x08,0xF0,0x00,0xFF,0x08,0x08,0x08,0x04,0x03,0xE0,0x10,0x08,0x10,0xE0,0x00,0x00,0x00,
  0x1F,0x00,0x00,0x00,0x00,0x1F,0x00,0x1F,0x00,0x00,0x00,0x00,0x00,0x07,0x08,0x10,0x08,0x07,0x08,0x10,0x00
} ;

// coron
static int SEGcoron_W=16 , SEGtcoron_H=32;
static uint8_t SEGcoron[] = {
0x00,0x00,0x00,0x00,0x00,0xC0,0xE0,0xE0,0xE0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x07,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xC0,0xE0,0xE0,0xE0,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x03,0x07,0x07,0x07,0x03,0x00,0x00,0x00,0x00,0x00,0x00,
} ;

// ----------------------------------------------------
// ここからCONFIGアイコン用ビットマップデータ

// 'image-WiFi', 32x26px
static int imageWiFi_W=32 , imageWiFi_H=26;
static uint8_t imageWiFi [] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x00, 
  0x01, 0xff, 0xff, 0x00, 0x03, 0xff, 0xff, 0xc0, 0x0f, 0xc0, 0x07, 0xe0, 0x1f, 0x00, 0x01, 0xf0, 
  0x3c, 0x1f, 0xf0, 0x78, 0x78, 0xff, 0xfe, 0x3c, 0xf1, 0xff, 0xff, 0x1e, 0xe3, 0xe0, 0x0f, 0x8e, 
  0x07, 0x80, 0x03, 0xc0, 0x0f, 0x1f, 0xf1, 0xe0, 0x0e, 0x3f, 0xf8, 0xe0, 0x00, 0x7f, 0xfc, 0x00, 
  0x00, 0xf0, 0x1e, 0x00, 0x00, 0xe0, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 
  0x00, 0x07, 0xc0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x07, 0xc0, 0x00, 
  0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00
};

// 'image-CONFIG', 32x32px
static int imageCONFIG_W=32 , imageCONFIG_H=32;
static uint8_t imageCONFIG [] = {
  0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xf8, 0x00, 0x07, 0x00, 0x08, 0x00, 0x0e, 0x00, 0x08, 0x00, 
  0x1a, 0x00, 0x08, 0x00, 0x3e, 0x00, 0x08, 0x00, 0x3e, 0x00, 0x08, 0x00, 0x20, 0x00, 0x08, 0x00, 
  0x20, 0x00, 0x08, 0x00, 0x20, 0x00, 0x08, 0x00, 0x27, 0x80, 0x08, 0x00, 0x20, 0x00, 0x08, 0x00, 
  0x20, 0x00, 0x1e, 0x00, 0x20, 0x00, 0x12, 0x00, 0x27, 0x83, 0x92, 0x60, 0x20, 0x06, 0xf3, 0x90, 
  0x20, 0x06, 0x41, 0x18, 0x20, 0x03, 0x0c, 0x30, 0x27, 0x81, 0x3e, 0x20, 0x20, 0x0f, 0x61, 0x3c, 
  0x20, 0x18, 0x41, 0x84, 0x27, 0x98, 0x41, 0x84, 0x23, 0x1e, 0x41, 0xbc, 0x20, 0x03, 0x23, 0x30, 
  0x20, 0x01, 0x1e, 0x20, 0x20, 0x02, 0x00, 0x30, 0x3f, 0xfe, 0x61, 0x98, 0x00, 0x03, 0xf3, 0xf0, 
  0x00, 0x01, 0x92, 0x60, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00
};

// 'image-ALARM', 32x32px
static int imageALARM_W=32 , imageALARM_H=32;
static uint8_t imageALARM [] = {
  0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0xf0, 0x3f, 0xc0, 0x03, 0xfc, 0x7f, 0xe0, 0x07, 0xfe, 
  0x7f, 0x80, 0x01, 0xfe, 0xfe, 0x07, 0xe0, 0x7f, 0xfc, 0x3f, 0xfc, 0x3f, 0xf8, 0x7f, 0xfe, 0x1f, 
  0xf0, 0xff, 0xff, 0x0f, 0x71, 0xf8, 0x1f, 0x8e, 0x63, 0xe0, 0x07, 0xc6, 0x27, 0xc3, 0xc3, 0xe4, 
  0x07, 0x83, 0xc1, 0xe0, 0x07, 0x83, 0xc1, 0xe0, 0x0f, 0x03, 0xc0, 0xf0, 0x0f, 0x03, 0xc0, 0xf0, 
  0x0f, 0x03, 0xc0, 0xf0, 0x0f, 0x03, 0xe0, 0xf0, 0x0f, 0x01, 0xf0, 0xf0, 0x0f, 0x00, 0xf8, 0xf0, 
  0x07, 0x80, 0x79, 0xe0, 0x07, 0x80, 0x31, 0xe0, 0x07, 0xc0, 0x03, 0xe0, 0x03, 0xe0, 0x07, 0xc0, 
  0x01, 0xf8, 0x1f, 0x80, 0x01, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0xc0, 
  0x03, 0x87, 0xe1, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00
};

// 'image-Laundry', 32x32px
static int imageLaundry_W=32 , imageLaundry_H=32;
static uint8_t imageLaundry []  = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x40, 0x01, 0x1c, 
  0x1f, 0xff, 0xff, 0xfc, 0x07, 0xff, 0xff, 0xf0, 0x00, 0x60, 0x01, 0x80, 0x00, 0x60, 0x01, 0x80, 
  0x00, 0xf8, 0x0f, 0x80, 0x07, 0xfc, 0x1f, 0xf0, 0x1f, 0xee, 0x39, 0xfc, 0x1c, 0x07, 0xf0, 0x0c, 
  0x18, 0x03, 0xe0, 0x0c, 0x18, 0x00, 0x00, 0x0c, 0x18, 0x00, 0x00, 0x0c, 0x19, 0x80, 0x00, 0xcc, 
  0x1f, 0xc0, 0x00, 0xfc, 0x0f, 0xc0, 0x00, 0xf8, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 
  0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 
  0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 
  0x00, 0xc0, 0x00, 0xc0, 0x00, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00
};
