#ifndef _DEBUG_
#define _DEBUG_

// Define DEBUG to enable Serial output
// e.g. add -DDEBUG to build flags or uncomment the line below
// #define DEBUG true

#ifdef DEBUG
  #define DEBUG_SERIAL_BEGIN(baud) Serial.begin(baud)
  #define DPRINT(...) Serial.print(__VA_ARGS__)
  #define DPRINTLN(...) Serial.println(__VA_ARGS__)
  #define DPRINTF(...) Serial.printf(__VA_ARGS__)
#else
  #define DEBUG_SERIAL_BEGIN(baud) ((void)0)
  #define DPRINT(...) ((void)0)
  #define DPRINTLN(...) ((void)0)
  #define DPRINTF(...) ((void)0)
#endif

#endif
