/**
 * プロパティ LOAD/SAVE
 */
#ifndef PROPERTY_H
#define PROPERTY_H

#define property_FILE_NAME "/WeatherForecast.json"
#define PAN0NAME "室内"
#define PAN1NAME "屋内"
#define PAN2NAME "屋外"

typedef struct ARAM_s {
  int enable ;    // アラーム有効無効 1:有効 0:無効
  int timehour ;  // アラーム時間 時
  int timemin ;   // アラーム時間 分
  int melody ;    // アラームメロディ 0-3
  int wday[7];    // 曜日設定
} ARAM_t ;

class Property {
  private:
    String wifiAP ;      // Wi-Fi アクセスポイント
    String wifiPWD ;     // Wi-Fi パスワード
    String weatherURL;   // 天気予報取得用URL
    String regionCode ;  // 地域コード
    String regionName ;  // 都道府県名
    String cityName;     // 市町村名
    int areaCode;        // 予報区コード
    String pal0Name ;    // センサー配置名称 0
    String pal1Name ;    // センサー配置名称 1
    String pal2Name ;    // センサー配置名称 2
    ARAM_t aram[5] ;     // アラーム情報

  public:
    Property( ) ;
    bool LoadProperty( ) ;   // プロパティ情報のロード
    bool SaveProperty( ) ;   // プロパティ情報のセーブ

    String getWifiAP( ) { return wifiAP ; }     // Wi-Fi アクセスポイント
    String getWifiPWD( ) { return wifiPWD ; }   // Wi-Fi パスワード
    String getWeatherURL( ) { return weatherURL ; }  // 天気予報取得用URL

    String getRegionCode( ) { return regionCode ; } // 地域コード
    int getAreaCode( ) { return areaCode ; }        // 予報区コード
    String getRegionName() { return regionName ; }  // 都道府県名
    String getCityName() { return cityName ; }      // 市町村名
    const char * getPalName(int no) ; // センサー配置名称取得

    void setRegionCode(String code) { regionCode = code ; }     // 地域コード
    void setAreaCode(String code) { areaCode = code.toInt() ; } // 予報区コード 
    void setRegionName(String name) { regionName = name ; }     // 都道府県名
    void setCityName(String name) { cityName = name ; }         // 市町村名

    int getAramEnable(int no) { return aram[no].enable ; }      // アラーム有効無効取得
    int getAramTimeHour(int no) { return aram[no].timehour ; }   // アラーム時間 時取得
    int getAramTimeMin(int no) { return aram[no].timemin  ; }     // アラーム時間 分取得
    int getAramMelody(int no) { return aram[no].melody  ; }       // アラームメロディ取得
    int getAramWDay(int no, int wDay) { return aram[no].wday[wDay]; }  // アラーム曜日設定
    void setAramEnable(int no, int en) { aram[no].enable = en ; }        // アラーム有効無効設定
    void setAramTimeHour(int no, int hour) { aram[no].timehour = hour ; }   // アラーム時間 時設定
    void setAramTimeMin(int no, int min) { aram[no].timemin = min ; }       // アラーム時間 分設定
    void setAramMelody(int no, int mel) { aram[no].melody = mel ; }         // アラームメロディ設定
    void setAramWDay(int no, int wDay , int stat) { aram[no].wday[wDay] = stat ; }  // アラーム曜日設定

    bool isAramEnabled( ) ; // アラーム有効なものがあるか
} ;
 
extern Property property ;

#endif
